/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio2;

import android.media.AudioManager;
import android.media.AudioRecordingConfiguration;
import android.os.Build;
import android.telephony.PhoneStateListener;
import com.tencent.liteav.audio2.a;
import com.tencent.liteav.audio2.b;
import com.tencent.liteav.audio2.d;
import com.tencent.liteav.audio2.e;
import com.tencent.liteav.audio2.f;
import com.tencent.liteav.audio2.h;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.ThreadUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.Executor;

@JNINamespace(value="liteav::audio")
public class AndroidInterruptedStateListener
implements d.a,
e.b {
    public static final String TAG = "AndroidInterruptedStateListener";
    private static final int RECORDING_CONFIGS_LIMIT = 10;
    private static d mRecordingCallback;
    private volatile boolean mNeedNotify = false;
    private Object mObject = new Object();
    private final long mNativeRecordingConfigListener;
    private e mPhoneStateManager;

    public AndroidInterruptedStateListener(long nativeRecordingConfigListener) {
        this.mNativeRecordingConfigListener = nativeRecordingConfigListener;
        Log.d(TAG, "new AndroidInterruptedStateListener" + this.hashCode(), new Object[0]);
    }

    public void registerAudioRecordingCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return;
        }
        if (mRecordingCallback != null) {
            AndroidInterruptedStateListener.mRecordingCallback.a = this;
        }
        ThreadUtils.getUiThreadHandler().post(a.a(this));
        this.mNeedNotify = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAudioRecordingCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return;
        }
        if (mRecordingCallback == null) {
            return;
        }
        Object object = this.mObject;
        synchronized (object) {
            this.mNeedNotify = false;
            AndroidInterruptedStateListener.mRecordingCallback.a = null;
            ThreadUtils.getUiThreadHandler().post(b.a(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void OnRecordingConfigChanged(List<AudioRecordingConfiguration> configList) {
        if (configList == null) {
            return;
        }
        int n2 = Math.min(configList.size(), 10);
        RecordingConfig[] recordingConfigArray = new RecordingConfig[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            recordingConfigArray[i2] = new RecordingConfig();
            AudioRecordingConfiguration audioRecordingConfiguration = configList.get(i2);
            recordingConfigArray[i2].a = audioRecordingConfiguration.getClientAudioSessionId();
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 29) {
                if (Build.VERSION.SDK_INT < 29) continue;
                recordingConfigArray[i2].b = audioRecordingConfiguration.isClientSilenced();
                continue;
            }
            recordingConfigArray[i2].b = false;
        }
        Object object = this.mObject;
        synchronized (object) {
            if (this.mNeedNotify) {
                AndroidInterruptedStateListener.nativeNotifyAudioRecordingConfigChangedFromJava(this.mNativeRecordingConfigListener, recordingConfigArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterruptedByPhoneCall() {
        Object object = this.mObject;
        synchronized (object) {
            if (this.mNeedNotify) {
                AndroidInterruptedStateListener.nativeNotifyInterruptedByPhoneCallFromJava(this.mNativeRecordingConfigListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResumedByPhoneCall() {
        Object object = this.mObject;
        synchronized (object) {
            if (this.mNeedNotify) {
                AndroidInterruptedStateListener.nativeNotifyResumedByPhoneCallFromJava(this.mNativeRecordingConfigListener);
            }
            return;
        }
    }

    private static native void nativeNotifyAudioRecordingConfigChangedFromJava(long var0, RecordingConfig[] var2);

    private static native void nativeNotifyInterruptedByPhoneCallFromJava(long var0);

    private static native void nativeNotifyResumedByPhoneCallFromJava(long var0);

    static /* synthetic */ void lambda$unregisterAudioRecordingCallback$1(AndroidInterruptedStateListener this_) {
        if (this_.mPhoneStateManager != null) {
            e e2 = this_.mPhoneStateManager;
            if (e.b()) {
                e e3 = e2;
                try {
                    if (e3.a != null) {
                        e3.a.listen((PhoneStateListener)e3, 0);
                    }
                    e3.g = 0;
                    return;
                }
                catch (Throwable throwable) {
                    Log.e("PhoneStateManager", "stop listen phone state failed, " + throwable.getMessage(), new Object[0]);
                    return;
                }
            }
            if (Build.VERSION.SDK_INT >= 31) {
                e e4 = e2;
                try {
                    if (e4.d != null && e4.e != null) {
                        AudioManager.class.getMethod("removeOnModeChangedListener", e4.d).invoke((Object)e4.b, e4.e);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Log.e("PhoneStateManager", "remove mode changed listener failed, " + throwable.getMessage(), new Object[0]);
                    return;
                }
            }
            e.c();
        }
    }

    static /* synthetic */ void lambda$registerAudioRecordingCallback$0(AndroidInterruptedStateListener this_) {
        e e2;
        block13: {
            if (this_.mPhoneStateManager == null) {
                this_.mPhoneStateManager = new e(this_);
            }
            e2 = this_.mPhoneStateManager;
            if (e.b()) {
                e e3 = e2;
                try {
                    if (e3.a != null) {
                        e3.a.listen((PhoneStateListener)e3, 32);
                        break block13;
                    }
                    Log.w("PhoneStateManager", "TelephonyManager is null, start listen phone state failed.", new Object[0]);
                }
                catch (Throwable throwable) {
                    Log.e("PhoneStateManager", "start listen phone state failed, " + throwable.getMessage(), new Object[0]);
                }
            } else if (Build.VERSION.SDK_INT >= 31) {
                e e4 = e2;
                try {
                    Object object;
                    if (e4.d == null) {
                        e4.d = Class.forName("android.media.AudioManager$OnModeChangedListener");
                    }
                    if (e4.e == null) {
                        object = new e.a(e4);
                        e4.e = Proxy.newProxyInstance(e4.d.getClassLoader(), new Class[]{e4.d}, (InvocationHandler)object);
                    }
                    object = AudioManager.class.getMethod("addOnModeChangedListener", Executor.class, e4.d);
                    Executor executor = h.a(e4);
                    ((Method)object).invoke((Object)e4.b, executor, e4.e);
                }
                catch (Throwable throwable) {
                    Log.e("PhoneStateManager", "add mode changed listener failed, " + throwable.getMessage(), new Object[0]);
                }
            } else {
                e e5 = e2;
                if (Build.VERSION.SDK_INT >= 26 && e.c != null) {
                    Log.i("PhoneStateManager", "register audio playback callback.", new Object[0]);
                    e.c.a = e5;
                }
            }
        }
        e2.f.a(f.a(e2));
    }

    static {
        if (Build.VERSION.SDK_INT >= 24) {
            mRecordingCallback = new d();
        }
    }

    static class RecordingConfig {
        int a = 0;
        boolean b = false;

        public int getSessionId() {
            return this.a;
        }

        public boolean isSilenced() {
            return this.b;
        }
    }
}

