/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio2;

import android.media.AudioTimestamp;
import android.media.AudioTrack;
import android.os.Process;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::audio")
public class LiteavAudioTrack3 {
    private static final String TAG = "LiteavAudioTrack3";
    private static final int DEFAULT_LATENCY_MS = 160;
    private static final int HARDWARE_LATENCY_MS = 20;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MS = 1000000L;
    private static final long LATENCY_THRESHOLD_MS = 1000L;
    private AudioTrack mAudioTrack;
    private int mSampleRate = 0;
    private byte[] mPlayBuffer;
    private int mBufferSize = 0;
    private int mSystemOSVersion = 0;
    private int mWriteFrameIndex = 0;
    private int mBytesPerFrame = 0;

    private AudioTrack createStartedAudioTrack(int sampleRate, int channelConfig, int bufferSize, int streamType) {
        AudioTrack audioTrack = null;
        try {
            audioTrack = new AudioTrack(streamType, sampleRate, channelConfig, 2, bufferSize, 1);
            if (audioTrack.getState() != 1) {
                throw new RuntimeException("AudioTrack is not initialized.");
            }
            this.mWriteFrameIndex = 0;
            audioTrack.play();
            Log.i(TAG, "create AudioTrack success. sampleRate: %d, channelConfig: %d, bufferSize: %d, streamType: %s", sampleRate, channelConfig, bufferSize, LiteavAudioTrack3.streamTypeToString(streamType));
        }
        catch (Throwable throwable) {
            Log.w(TAG, "create AudioTrack failed. sampleRate: %d, channelConfig: %d, bufferSize: %d, streamType: %s", sampleRate, channelConfig, bufferSize, LiteavAudioTrack3.streamTypeToString(streamType));
            this.destroyAudioTrack(audioTrack);
            audioTrack = null;
        }
        return audioTrack;
    }

    private void destroyAudioTrack(AudioTrack audioTrack) {
        if (audioTrack == null) {
            return;
        }
        try {
            if (audioTrack.getPlayState() == 3) {
                audioTrack.stop();
                audioTrack.flush();
            }
            audioTrack.release();
            return;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "stop AudioTrack failed.", throwable);
            return;
        }
    }

    private static String streamTypeToString(int stream) {
        switch (stream) {
            case 0: {
                return "STREAM_VOICE_CALL";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
            case 2: {
                return "STREAM_RING";
            }
            case 4: {
                return "STREAM_ALARM";
            }
            case 5: {
                return "STREAM_NOTIFICATION";
            }
            case 1: {
                return "STREAM_SYSTEM";
            }
        }
        return "STREAM_INVALID";
    }

    public int startPlayout(int streamType, int sampleRate, int channelCount, int frameSize) {
        this.mBytesPerFrame = channelCount * 2;
        this.mSampleRate = sampleRate;
        int n2 = channelCount == 1 ? 4 : 12;
        int n3 = AudioTrack.getMinBufferSize((int)sampleRate, (int)n2, (int)2);
        if (n3 <= 0) {
            Log.e(TAG, "AudioTrack.getMinBufferSize return error: ".concat(String.valueOf(n3)), new Object[0]);
            return -2;
        }
        int[] nArray = new int[]{streamType, 0, 3, 1};
        for (int i2 = 0; i2 < 4 && this.mAudioTrack == null; ++i2) {
            int n4 = nArray[i2];
            for (int i3 = 1; i3 <= 2 && this.mAudioTrack == null; ++i3) {
                this.mBufferSize = n3 * i3;
                if (this.mBufferSize < frameSize * 4 && i3 < 2) continue;
                this.mAudioTrack = this.createStartedAudioTrack(sampleRate, n2, this.mBufferSize, n4);
            }
        }
        if (this.mAudioTrack == null) {
            return -1;
        }
        this.mSystemOSVersion = LiteavSystemInfo.getSystemOSVersionInt();
        Process.setThreadPriority((int)-19);
        return 0;
    }

    public int write(ByteBuffer buffer, int offset, int size, boolean isNonBlockingWrite) {
        int n2;
        if (this.mAudioTrack == null) {
            return -1;
        }
        buffer.position(offset);
        if (this.mSystemOSVersion >= 21) {
            int n3 = isNonBlockingWrite ? 1 : 0;
            n2 = this.mAudioTrack.write(buffer, size, n3);
        } else {
            if (this.mPlayBuffer == null || this.mPlayBuffer.length < size) {
                this.mPlayBuffer = new byte[size];
            }
            buffer.get(this.mPlayBuffer, 0, size);
            n2 = this.mAudioTrack.write(this.mPlayBuffer, 0, size);
        }
        if (n2 < 0) {
            Log.e(TAG, "write audio data to AudioTrack failed. ".concat(String.valueOf(n2)), new Object[0]);
            return -1;
        }
        this.mWriteFrameIndex += n2 / this.mBytesPerFrame;
        return n2;
    }

    public void stopPlayout() {
        LiteavAudioTrack3 liteavAudioTrack3 = this;
        liteavAudioTrack3.destroyAudioTrack(liteavAudioTrack3.mAudioTrack);
        this.mAudioTrack = null;
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    public int getUnderrunCount() {
        int n2 = 0;
        if (this.mAudioTrack == null) {
            return 0;
        }
        try {
            if (this.mSystemOSVersion >= 24) {
                n2 = this.mAudioTrack.getUnderrunCount();
            }
        }
        catch (Throwable throwable) {
            Log.w(TAG, "get under run count exception " + throwable.getMessage(), new Object[0]);
        }
        return n2;
    }

    public int getPlayoutLatencyMs() {
        if (this.mAudioTrack == null) {
            return 160;
        }
        if (this.mSystemOSVersion < 23) {
            return 160;
        }
        int n2 = 160;
        try {
            n2 = this.getLatencyByTimestamp();
        }
        catch (Throwable throwable) {
            Log.w(TAG, "get latency exception " + throwable.getMessage(), new Object[0]);
        }
        return n2;
    }

    private int getLatencyByTimestamp() {
        long l2;
        AudioTimestamp audioTimestamp = new AudioTimestamp();
        if (!this.mAudioTrack.getTimestamp(audioTimestamp)) {
            Log.w(TAG, "fail to get AudioTrack timestamp", new Object[0]);
            return 160;
        }
        long l3 = (long)this.mWriteFrameIndex - audioTimestamp.framePosition;
        long l4 = this.lengthBytesToNano(l3);
        long l5 = audioTimestamp.nanoTime + l4;
        int n2 = (int)((l5 - (l2 = System.nanoTime())) / 1000000L) + 20;
        if (n2 > 0 && (long)n2 < 1000L) {
            return n2;
        }
        return 160;
    }

    private long lengthBytesToNano(long frameIndexDelta) {
        return frameIndexDelta * 1000000000L / (long)this.mSampleRate;
    }
}

