/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio2;

import android.content.Context;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.os.Process;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::audio")
public class SystemLoopbackRecorder2 {
    private static final String TAG = "SystemLoopbackRecorder2";
    private static final Object mLock = new Object();
    private static MediaProjection mMediaProjection = null;
    private static volatile long mNativeSystemLoopbackRecorder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyMediaProjectionState(MediaProjection mediaProjection) {
        Log.i(TAG, "Received MediaProjection state " + (mediaProjection != null), new Object[0]);
        Object object = mLock;
        synchronized (object) {
            mMediaProjection = mediaProjection;
            SystemLoopbackRecorder2.setMediaProjectionSession();
            return;
        }
    }

    public SystemLoopbackRecorder2(long nativeSystemLoopbackRecorder) {
        mNativeSystemLoopbackRecorder = nativeSystemLoopbackRecorder;
    }

    public MediaProjection getMediaProjection() {
        return mMediaProjection;
    }

    public void releaseNativeSystemLoopbackRecorder() {
        mNativeSystemLoopbackRecorder = 0L;
    }

    public static void setMediaProjectionSession() {
        if (mMediaProjection == null) {
            Log.i(TAG, "MediaProjection is null.", new Object[0]);
            return;
        }
        if (mNativeSystemLoopbackRecorder != 0L) {
            SystemLoopbackRecorder2.nativeSetMediaProjectionSession(mNativeSystemLoopbackRecorder, mMediaProjection);
        }
    }

    private static native void nativeSetMediaProjectionSession(long var0, MediaProjection var2);

    static class Recorder {
        private AudioRecord a;
        private AudioManager b;

        public Recorder() {
            Context context = ContextUtils.getApplicationContext();
            ContextUtils.getApplicationContext();
            this.b = (AudioManager)context.getSystemService("audio");
        }

        public int startRecording(MediaProjection mediaProjection, int sampleRate, int channelCount, int frameSize, int loopbackRecordStrategy) {
            Recorder recorder;
            if (loopbackRecordStrategy == 0) {
                recorder = this;
                try {
                    if (recorder.b != null) {
                        recorder.b.setAllowedCapturePolicy(3);
                    }
                }
                catch (Throwable throwable) {
                    Log.e(SystemLoopbackRecorder2.TAG, "ForbidCaptureAudioFromCurrentApp error " + throwable.getMessage(), new Object[0]);
                }
            }
            recorder = this;
            int n2 = 0;
            if (recorder.b != null) {
                n2 = recorder.b.getMode();
            }
            int n3 = n2;
            this.a(0);
            this.a = Recorder.a(mediaProjection, sampleRate, channelCount, frameSize);
            this.a(n3);
            if (this.a == null) {
                return -1;
            }
            Process.setThreadPriority((int)-19);
            return 0;
        }

        public void stopRecording() {
            Recorder.a(this.a);
            this.a = null;
        }

        public int read(ByteBuffer buffer, int size) {
            if (this.a == null) {
                return -1;
            }
            buffer.position(0);
            int n2 = this.a.read(buffer, size);
            if (n2 <= 0) {
                Log.e(SystemLoopbackRecorder2.TAG, "Read failed ".concat(String.valueOf(n2)), new Object[0]);
                return -1;
            }
            return n2;
        }

        private static AudioRecord a(MediaProjection mediaProjection, int n2, int n3, int n4) {
            AudioRecord audioRecord = null;
            AudioPlaybackCaptureConfiguration.Builder builder = new AudioPlaybackCaptureConfiguration.Builder(mediaProjection);
            builder.addMatchingUsage(1);
            builder.addMatchingUsage(14);
            AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration = builder.build();
            if (audioPlaybackCaptureConfiguration == null) {
                return null;
            }
            int n5 = n3 == 1 ? 16 : 12;
            AudioFormat audioFormat = new AudioFormat.Builder().setEncoding(2).setSampleRate(n2).setChannelMask(n5).build();
            int n6 = AudioRecord.getMinBufferSize((int)n2, (int)n5, (int)2);
            for (int i2 = 1; i2 <= 2 && audioRecord == null; ++i2) {
                int n7 = n6 * i2;
                if (n7 < n4 * 4 && i2 < 2) continue;
                try {
                    audioRecord = new AudioRecord.Builder().setAudioFormat(audioFormat).setBufferSizeInBytes(n7).setAudioPlaybackCaptureConfig(audioPlaybackCaptureConfiguration).build();
                    if (audioRecord.getState() != 1) {
                        Log.e(SystemLoopbackRecorder2.TAG, "Audio record state error", new Object[0]);
                        Recorder.a(audioRecord);
                        audioRecord = null;
                        continue;
                    }
                    audioRecord.startRecording();
                    Log.i(SystemLoopbackRecorder2.TAG, "Create audio record success", new Object[0]);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.w(SystemLoopbackRecorder2.TAG, "Create record error " + throwable.getMessage(), new Object[0]);
                    Recorder.a(audioRecord);
                    audioRecord = null;
                }
            }
            return audioRecord;
        }

        private static void a(AudioRecord audioRecord) {
            if (audioRecord == null) {
                return;
            }
            try {
                if (audioRecord.getRecordingState() == 3) {
                    audioRecord.stop();
                }
                audioRecord.release();
                return;
            }
            catch (Throwable throwable) {
                Log.e(SystemLoopbackRecorder2.TAG, "Destroy AudioRecord failed." + throwable.getMessage(), new Object[0]);
                return;
            }
        }

        private void a(int n2) {
            try {
                if (this.b != null) {
                    this.b.setMode(n2);
                }
                return;
            }
            catch (Throwable throwable) {
                Log.e(SystemLoopbackRecorder2.TAG, "Set audio mode exception " + throwable.getMessage(), new Object[0]);
                return;
            }
        }
    }
}

