/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.storage;

import com.tencent.liteav.base.annotations.JNINamespace;

@JNINamespace(value="liteav")
public class PersistStorageMmkv {
    private long mNativePersistStorageMmkv = 0L;

    public PersistStorageMmkv(String domain) {
        this.mNativePersistStorageMmkv = PersistStorageMmkv.nativeCreatePersistStorageMmkv(domain);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativePersistStorageMmkv != 0L) {
            PersistStorageMmkv.nativeDestroyPersistStorageMmkv(this.mNativePersistStorageMmkv);
        }
    }

    public void put(String key, int value) {
        if (this.mNativePersistStorageMmkv == 0L) {
            return;
        }
        try {
            PersistStorageMmkv.nativePutInt32(this.mNativePersistStorageMmkv, key, value);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void put(String key, long value) {
        if (this.mNativePersistStorageMmkv == 0L) {
            return;
        }
        try {
            PersistStorageMmkv.nativePutLong(this.mNativePersistStorageMmkv, key, value);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void put(String key, String value) {
        if (this.mNativePersistStorageMmkv == 0L) {
            return;
        }
        try {
            PersistStorageMmkv.nativePutString(this.mNativePersistStorageMmkv, key, value);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void clear(String key) {
        if (this.mNativePersistStorageMmkv == 0L) {
            return;
        }
        try {
            PersistStorageMmkv.nativeClear(this.mNativePersistStorageMmkv, key);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void commit() {
        if (this.mNativePersistStorageMmkv == 0L) {
            return;
        }
        try {
            PersistStorageMmkv.nativeCommit(this.mNativePersistStorageMmkv);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public Integer getInt(String key) {
        Integer value;
        if (this.mNativePersistStorageMmkv == 0L) {
            return null;
        }
        try {
            value = PersistStorageMmkv.nativeGetInt32(this.mNativePersistStorageMmkv, key);
        }
        catch (Throwable throwable) {
            return null;
        }
        return value;
    }

    public Long getLong(String key) {
        Long value;
        if (this.mNativePersistStorageMmkv == 0L) {
            return null;
        }
        try {
            value = PersistStorageMmkv.nativeGetLong(this.mNativePersistStorageMmkv, key);
        }
        catch (Throwable throwable) {
            return null;
        }
        return value;
    }

    public String getString(String key) {
        String value;
        if (this.mNativePersistStorageMmkv == 0L) {
            return null;
        }
        try {
            value = PersistStorageMmkv.nativeGetString(this.mNativePersistStorageMmkv, key);
        }
        catch (Throwable throwable) {
            return null;
        }
        return value;
    }

    public String[] getAllKeys() {
        String[] stringArray;
        if (this.mNativePersistStorageMmkv == 0L) {
            return new String[0];
        }
        try {
            stringArray = PersistStorageMmkv.nativeGetAllKeys(this.mNativePersistStorageMmkv);
        }
        catch (Throwable throwable) {
            return new String[0];
        }
        if (stringArray == null) {
            return new String[0];
        }
        return stringArray;
    }

    private static native long nativeCreatePersistStorageMmkv(String var0);

    private static native void nativeDestroyPersistStorageMmkv(long var0);

    private static native void nativePutInt32(long var0, String var2, int var3);

    private static native void nativePutLong(long var0, String var2, long var3);

    private static native void nativePutString(long var0, String var2, String var3);

    private static native void nativeClear(long var0, String var2);

    private static native void nativeCommit(long var0);

    private static native Integer nativeGetInt32(long var0, String var2);

    private static native Long nativeGetLong(long var0, String var2);

    private static native String nativeGetString(long var0, String var2);

    private static native String[] nativeGetAllKeys(long var0);
}

