/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.videobase.TXCCloudVideoViewMethodInvoker;
import com.tencent.liteav.videoconsumer.renderer.RenderViewHelperInterface;
import com.tencent.liteav.videoconsumer.renderer.k;
import com.tencent.liteav.videoconsumer.renderer.l;
import com.tencent.liteav.videoconsumer.renderer.m;
import com.tencent.liteav.videoconsumer.renderer.n;
import com.tencent.liteav.videoconsumer.renderer.o;
import com.tencent.liteav.videoconsumer.renderer.p;
import com.tencent.liteav.videoconsumer.renderer.q;
import com.tencent.rtmp.ui.TXCloudVideoView;

public final class j
extends RenderViewHelperInterface
implements TextureView.SurfaceTextureListener {
    private final String a;
    private final CustomHandler b = new CustomHandler(Looper.getMainLooper());
    private final b c = new b();
    private final RenderViewHelperInterface.RenderViewListener d;
    private final TXCloudVideoView e;
    private TextureView f;
    private boolean g = false;
    private final Size h = new Size();
    private GLConstants.GLScaleType i = null;
    private boolean j = true;
    private boolean k = false;
    private Matrix l = new Matrix();
    private boolean m = true;
    private boolean n = false;
    private SurfaceTexture o;
    private Surface p;
    private final Size q = new Size();

    public j(String string, TXCloudVideoView tXCloudVideoView, RenderViewHelperInterface.RenderViewListener renderViewListener) {
        this(string, renderViewListener, tXCloudVideoView, null);
        if (this.e == null) {
            LiteavLog.e(this.a, "construct: txCloudVideoView is null.");
            return;
        }
        LiteavLog.i(this.a, "construct: txCloudVideoView=" + (Object)((Object)this.e));
        this.n = false;
        this.b.post(com.tencent.liteav.videoconsumer.renderer.k.a(this));
    }

    public j(String string, TextureView textureView, RenderViewHelperInterface.RenderViewListener renderViewListener) {
        this(string, renderViewListener, null, textureView);
        if (this.f == null) {
            LiteavLog.e(this.a, "construct: textureView is null.");
            return;
        }
        LiteavLog.i(this.a, "construct: textureView=" + this.f);
        this.n = true;
        this.b.post(com.tencent.liteav.videoconsumer.renderer.l.a(this));
    }

    private j(String string, RenderViewHelperInterface.RenderViewListener renderViewListener, TXCloudVideoView tXCloudVideoView, TextureView textureView) {
        this.a = string + "TextureViewRenderHelper_" + this.hashCode();
        this.d = renderViewListener;
        this.e = tXCloudVideoView;
        this.f = textureView;
    }

    @Override
    public final void release(boolean clearLastImage) {
        this.b.post(com.tencent.liteav.videoconsumer.renderer.m.a(this, clearLastImage));
    }

    @Override
    public final Matrix getTransformMatrix(int width, int height) {
        Matrix matrix = new Matrix(this.l);
        matrix.postScale(1.0f, -1.0f, (float)width / 2.0f, (float)height / 2.0f);
        return matrix;
    }

    @Override
    public final void checkViewAvailability() {
        this.b.runOrPost(com.tencent.liteav.videoconsumer.renderer.n.a(this));
    }

    private static String a(View view) {
        if (view == null) {
            return "null";
        }
        String string = String.format("%s: is_shown:%b, visibility:%s, window_visibility:%s, size:%dx%d", view.getClass().getSimpleName(), view.isShown(), view.getVisibility(), view.getWindowVisibility(), view.getWidth(), view.getHeight());
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 19) {
            string = string + String.format(", is_attached:%b", view.isAttachedToWindow());
        }
        if (view instanceof TextureView) {
            TextureView textureView = (TextureView)view;
            string = string + String.format(", is_surface_available:%s", textureView.isAvailable());
        }
        return string;
    }

    @Override
    public final synchronized void updateVideoFrameInfo(GLConstants.GLScaleType scaleType, int width, int height, boolean isHDR) {
        if (this.i == scaleType && width == this.h.width && height == this.h.height) {
            return;
        }
        LiteavLog.i(this.a, "updateVideoFrameInfo: scaleType: %s, width: %d, height: %d", new Object[]{scaleType, width, height});
        this.i = scaleType;
        this.h.set(width, height);
        this.b.runOrPost(com.tencent.liteav.videoconsumer.renderer.o.a(this));
    }

    @Override
    public final boolean isUsingTextureView() {
        return true;
    }

    @Override
    public final boolean isVisible() {
        return this.j;
    }

    @Override
    public final synchronized void enableNonUniformScale(boolean enable) {
        if (this.m == enable) {
            return;
        }
        this.m = enable;
        LiteavLog.i(this.a, "enableNonUniformScale: ".concat(String.valueOf(enable)));
        this.b.post(com.tencent.liteav.videoconsumer.renderer.p.a(this));
    }

    private void a() {
        if (this.f == null && this.e == null) {
            LiteavLog.e(this.a, "setup: null view");
            return;
        }
        if (this.e != null) {
            this.f = TXCCloudVideoViewMethodInvoker.getFreeTextureView(this.e);
            if (this.f == null) {
                this.f = new TextureView(this.e.getContext());
            }
            TXCCloudVideoViewMethodInvoker.addViewInternal(this.e, this.f);
            LiteavLog.i(this.a, "setup: add view: " + this.f);
        }
        this.f.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        if (!this.f.isAvailable()) {
            LiteavLog.i(this.a, "setup: textureView not available.");
            this.checkViewAvailability();
            return;
        }
        Size size = new Size(this.f.getWidth(), this.f.getHeight());
        LiteavLog.i(this.a, "setup: " + this.f + "," + size + ", isShown=" + this.f.isShown());
        j j2 = this;
        j2.a(j2.f.getSurfaceTexture(), size.width, size.height);
    }

    private synchronized void b() {
        double d2;
        if (this.f == null) {
            return;
        }
        if (!this.m) {
            this.l = new Matrix();
            this.f.setTransform(this.l);
            this.f.postInvalidate();
            LiteavLog.i(this.c.a("resetTextureViewRenderMatrix"), this.a, "resetTextureViewRenderMatrix", new Object[0]);
            return;
        }
        Size size = new Size(this.f.getWidth(), this.f.getHeight());
        if (!this.h.isValid() || !size.isValid()) {
            LiteavLog.i(this.c.a("updateTextureViewMatrixFailure"), this.a, "updateTextureViewRenderMatrix, invalid frameSize: %s, viewSize: %s", this.h.toString(), size.toString());
            return;
        }
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = size.aspectRatio();
        double d6 = this.h.aspectRatio();
        if (d2 < d5) {
            if (this.i == GLConstants.GLScaleType.b) {
                d3 = d6 / d5;
            } else if (this.i == GLConstants.GLScaleType.a) {
                d4 = d5 / d6;
            }
        } else if (this.i == GLConstants.GLScaleType.b) {
            d4 = d5 / d6;
        } else if (this.i == GLConstants.GLScaleType.a) {
            d3 = d6 / d5;
        }
        Matrix matrix = new Matrix();
        matrix.setScale((float)d3, (float)d4, (float)size.width / 2.0f, (float)size.height / 2.0f);
        if (!matrix.equals((Object)this.f.getTransform(new Matrix()))) {
            this.f.setTransform(matrix);
            this.f.postInvalidate();
            LiteavLog.i(this.c.a("updateTextureViewMatrix"), this.a, "updateTextureViewRenderMatrix: view: %s, scaleX: %.2f, scaleY: %.2f, frame: %s, view: %s", this.f, d3, d4, this.h, size);
        }
        this.l = matrix;
    }

    private synchronized void c() {
        if (this.f == null || this.n) {
            return;
        }
        if (!this.m && this.i == GLConstants.GLScaleType.b) {
            this.f.setOpaque(false);
            return;
        }
        this.f.setOpaque(true);
    }

    private void a(SurfaceTexture surfaceTexture, int n2, int n3) {
        if (this.o == null) {
            this.o = surfaceTexture;
        } else if (surfaceTexture != this.o) {
            LiteavLog.i(this.a, "notifySurfaceChanged: reset surfaceTexture: " + this.o);
            this.f.setSurfaceTexture(this.o);
        }
        this.q.set(n2, n3);
        if (this.p == null) {
            this.p = new Surface(this.o);
            if (this.d != null) {
                this.d.onSurfaceChanged(this.p, false);
            }
        }
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        LiteavLog.i(this.a, "onSurfaceTextureAvailable, size:" + width + "x" + height + " surfaceTexture:" + surfaceTexture);
        this.a(surfaceTexture, width, height);
        this.b();
        this.checkViewAvailability();
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        LiteavLog.i(this.c.a("surfaceSizeChanged"), this.a, "onSurfaceTextureSizeChanged: %dx%d --> %dx%d", this.q.width, this.q.height, width, height);
        boolean bl = this.q.width > this.q.height;
        this.a(surface, width, height);
        this.b();
        if (bl != width > height) {
            j j2 = this;
            if (j2.d == null || j2.f == null) {
                return;
            }
            Bitmap bitmap = j2.f.getBitmap();
            if (bitmap != null) {
                j2.d.onRequestRedraw(bitmap);
            }
        }
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        LiteavLog.i(this.a, "onSurfaceTextureDestroyed surface:".concat(String.valueOf(surface)));
        this.k = false;
        return this.o != surface;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.k) {
            return;
        }
        this.k = true;
        this.checkViewAvailability();
        this.b.post(com.tencent.liteav.videoconsumer.renderer.q.a(this));
    }

    static /* synthetic */ void a(j j2) {
        j2.b();
        j2.c();
    }

    static /* synthetic */ void b(j j2) {
        j2.b();
        j2.c();
        if (j2.f != null && j2.f.getVisibility() != 0) {
            j2.f.setVisibility(0);
        }
    }

    static /* synthetic */ void c(j j2) {
        if (j2.f == null) {
            LiteavLog.w(j2.a, "checkViewAvailability: textureView is null");
            return;
        }
        if (!(j2.f.isAvailable() && j2.f.getWidth() != 0 && j2.f.getHeight() != 0 && j2.f.isShown())) {
            LiteavLog.w(j2.a, "checkViewAvailability: %s, %s", com.tencent.liteav.videoconsumer.renderer.j.a((View)j2.f), com.tencent.liteav.videoconsumer.renderer.j.a((View)j2.e));
        }
        if (j2.e != null && j2.f.getVisibility() != 0) {
            j2.f.setVisibility(0);
        }
        j2.j = j2.f.isShown();
    }

    static /* synthetic */ void a(j j2, boolean bl) {
        LiteavLog.i(j2.a, "release: clearLastImage=".concat(String.valueOf(bl)));
        if (j2.f == null) {
            return;
        }
        if (j2.f.getSurfaceTextureListener() == j2) {
            j2.f.setSurfaceTextureListener(null);
        }
        if (j2.p != null) {
            j2.p.release();
            j2.p = null;
        }
        if (j2.o != null && j2.f.getSurfaceTexture() != j2.o) {
            j2.o.release();
        }
        if (j2.e != null) {
            TXCCloudVideoViewMethodInvoker.removeViewInternal(j2.e, j2.f, bl);
        }
        j2.o = null;
        j2.f = null;
        j2.g = true;
    }

    static /* synthetic */ void d(j j2) {
        j2.a();
    }

    static /* synthetic */ void e(j j2) {
        j2.a();
    }

    static /* synthetic */ void f(j j2) {
        j j3 = j2;
        LiteavLog.i(j3.a, "first frame rendered");
        if (j3.e == null || j3.f == null) {
            return;
        }
        TXCCloudVideoViewMethodInvoker.notifyFirstFrameRendered(j3.e, j3.f);
    }
}

