/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Process;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.k;
import com.tencent.liteav.videoproducer.capture.CameraCaptureParams;
import com.tencent.liteav.videoproducer.capture.CameraEventCallback;
import com.tencent.liteav.videoproducer.capture.FaceRect;

@JNINamespace(value="liteav::video")
public abstract class CameraControllerInterface {
    private static final String TAG = "CameraControllerInterface";
    public static final int CAMERA_ERROR_UNKNOWN = 0;
    public static final int CAMERA_ERROR_OCCUPIED = 1;
    public static final int CAMERA_ERROR_DISABLED = 2;
    public static final int CAMERA_ERROR_SERVER_DIED = 3;
    public static final int CAMERA_ERROR_DEVICE = 4;
    public static final int CAMERA_FACE_AE_STRATEGY_OFF = 0;
    public static final int CAMERA_FACE_AE_STRATEGY_ALWAYS_ON = 1;
    public static final int CAMERA_FACE_AE_STRATEGY_FRONT_ONLY = 2;
    public static final int CAMERA_FACE_AE_STRATEGY_BACK_ONLY = 3;

    public static CameraControllerInterface createCameraController(int cameraApiType, Handler callbackHandler) {
        CameraControllerInterface cameraControllerInterface;
        a a2 = a.a(cameraApiType);
        switch (a2) {
            case c: {
                Handler handler = callbackHandler;
                handler.getClass();
                Handler handler2 = handler;
                cameraControllerInterface = new com.tencent.liteav.videoproducer.capture.b.a(new com.tencent.liteav.videoproducer.capture.a(handler2));
                break;
            }
            default: {
                cameraControllerInterface = new com.tencent.liteav.videoproducer.capture.a.a();
            }
        }
        LiteavLog.i(TAG, "createCameraController, CameraAPIType:" + (Object)((Object)a2) + ", return camera controller: " + cameraControllerInterface);
        return cameraControllerInterface;
    }

    public static boolean hasCameraPermission() {
        boolean bl = true;
        Context context = ContextUtils.getApplicationContext();
        if (context != null && LiteavSystemInfo.getSystemOSVersionInt() >= 23) {
            bl = 0 == context.checkPermission("android.permission.CAMERA", Process.myPid(), Process.myUid());
        }
        return bl;
    }

    public abstract void setCameraRotationCorrectionValue(int var1);

    public abstract void enableCameraDynamicFps(boolean var1);

    public abstract void setFaceAEStrategy(int var1);

    public abstract void enableFaceDetection(boolean var1);

    public abstract FaceRect getCameraFaceRect();

    public abstract int getCurrentCameraISO();

    public abstract boolean startCapture(CameraCaptureParams var1, SurfaceTexture var2, CameraEventCallback var3);

    public abstract void stopCapture();

    public abstract void startAutoFocusAtPosition(int var1, int var2);

    public abstract void setZoom(float var1);

    public abstract void setExposureCompensationNormalization(float var1);

    public abstract void setExposureCompensation(int var1);

    public abstract float getExposureCompensationStep();

    public abstract k getCameraSystemRotation();

    public abstract int getCameraSystemRotationValue();

    public abstract int getMaxZoom();

    public abstract Size getPreviewSize();

    public abstract void turnOnTorch(boolean var1);

    public abstract void enableTapToFocus(boolean var1);

    public abstract boolean isZoomSupported();

    public abstract boolean isTorchSupported();

    public abstract boolean isCameraAutoFocusFaceModeSupported();

    public abstract boolean isCameraFocusPositionInPreviewSupported();

    public abstract boolean isCurrentPreviewSizeAspectRatioMatch(int var1, int var2, boolean var3);

    public static enum a {
        a(0),
        b(1),
        c(2);

        private final int mValue;

        private a(int n3) {
            this.mValue = n3;
        }

        public static a a(int n2) {
            for (a a2 : com.tencent.liteav.videoproducer.capture.CameraControllerInterface$a.values()) {
                if (a2.mValue != n2) continue;
                return a2;
            }
            return b;
        }
    }
}

