/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.c;
import com.tencent.liteav.videoproducer2.MediaCodecExceptionJni;
import com.tencent.liteav.videoproducer2.MediaCodecFrameJni;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="liteav::video")
public class MediaCodecCallbackJni
extends MediaCodec.Callback {
    private static final String TAG = "MediaCodecCallbackJni";
    private MediaCodec mMediaCodec;
    private long mNativeHandler;

    public MediaCodecCallbackJni(MediaCodec mediaCodec, long nativeHandler) {
        this.mMediaCodec = mediaCodec;
        this.mNativeHandler = nativeHandler;
        LiteavLog.i(TAG, "Create callback for:".concat(String.valueOf(mediaCodec)));
    }

    public void destroy() {
        LiteavLog.i(TAG, "Destroy callback for:" + this.mMediaCodec);
        this.mMediaCodec = null;
        this.mNativeHandler = 0L;
    }

    public void onInputBufferAvailable(MediaCodec codec, int index) {
    }

    public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
        if (this.mMediaCodec != codec || this.mNativeHandler == 0L) {
            return;
        }
        if (info.size == 0 && (info.flags & 4) == 0) {
            LiteavLog.e(TAG, "size is zero, but it isn't end of stream");
            return;
        }
        ByteBuffer byteBuffer = LiteavSystemInfo.getSystemOSVersionInt() >= 21 ? codec.getOutputBuffer(index) : codec.getOutputBuffers()[index];
        if (byteBuffer == null) {
            return;
        }
        byteBuffer.position(info.offset);
        byteBuffer.limit(info.offset + info.size);
        MediaCodecFrameJni mediaCodecFrameJni = new MediaCodecFrameJni();
        new MediaCodecFrameJni().data = ByteBuffer.allocateDirect(info.size);
        mediaCodecFrameJni.data.put(byteBuffer);
        boolean bl = (info.flags & 1) > 0;
        mediaCodecFrameJni.nalType = bl ? c.b : c.c;
        mediaCodecFrameJni.pts = TimeUnit.MICROSECONDS.toMillis(info.presentationTimeUs);
        codec.releaseOutputBuffer(index, false);
        MediaCodecCallbackJni mediaCodecCallbackJni = this;
        mediaCodecCallbackJni.nativeOnOutputBufferAvailable(mediaCodecCallbackJni.mNativeHandler, codec, mediaCodecFrameJni, info.flags);
    }

    public void onError(MediaCodec codec, MediaCodec.CodecException exception) {
        if (this.mMediaCodec != codec || this.mNativeHandler == 0L) {
            return;
        }
        MediaCodecExceptionJni mediaCodecExceptionJni = MediaCodecExceptionJni.createException();
        MediaCodecExceptionJni.createException().hasException = true;
        mediaCodecExceptionJni.systemErrorCode = exception.getErrorCode();
        mediaCodecExceptionJni.isErrorRecoverable = exception.isRecoverable() || exception.isTransient();
        MediaCodecCallbackJni mediaCodecCallbackJni = this;
        mediaCodecCallbackJni.nativeOnError(mediaCodecCallbackJni.mNativeHandler, codec, mediaCodecExceptionJni);
    }

    public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
        if (this.mMediaCodec != codec || this.mNativeHandler == 0L) {
            return;
        }
        LiteavLog.i(TAG, "encoder output format changed %s", format);
        MediaCodecCallbackJni mediaCodecCallbackJni = this;
        mediaCodecCallbackJni.nativeOnOutputFormatChanged(mediaCodecCallbackJni.mNativeHandler, codec, format);
    }

    private native void nativeOnOutputBufferAvailable(long var1, MediaCodec var3, MediaCodecFrameJni var4, int var5);

    private native void nativeOnOutputFormatChanged(long var1, MediaCodec var3, MediaFormat var4);

    private native void nativeOnError(long var1, MediaCodec var3, MediaCodecExceptionJni var4);
}

