/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.os.Looper;
import android.view.OrientationEventListener;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.k;
import com.tencent.liteav.base.util.r;
import com.tencent.liteav.videobase.videobase.SystemDisplayInfo;

@JNINamespace(value="liteav::video")
public class SystemNotificationMonitor
extends OrientationEventListener
implements r.a {
    private static final int SENSOR_ROTATION_DETECTION_THRESHOLD = 30;
    private int mLastOrientation = -1;
    private volatile r mTimer = null;
    private volatile long mListenerPtr = 0L;
    private k mSensorRotation = null;
    private k mDisplayRotation = null;

    public SystemNotificationMonitor() {
        super(ContextUtils.getApplicationContext());
    }

    public synchronized void initialize(long listenerPtr) {
        this.mListenerPtr = listenerPtr;
        if (this.mTimer != null) {
            return;
        }
        super.enable();
        this.mTimer = new r(Looper.getMainLooper(), this);
        this.mTimer.a(200);
    }

    public synchronized void uninitialize() {
        super.disable();
        this.mListenerPtr = 0L;
        if (this.mTimer != null) {
            this.mTimer.a();
            this.mTimer = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onOrientationChanged(int orientation) {
        if (orientation == -1) {
            return;
        }
        if (this.mLastOrientation != -1 && Math.abs(orientation - this.mLastOrientation) <= 30) {
            return;
        }
        this.mLastOrientation = orientation;
        if (orientation <= 45) ** GOTO lbl-1000
        if (orientation <= 135) {
            var2_2 = k.b;
        } else if (orientation <= 225) {
            var2_2 = k.c;
        } else if (orientation <= 315) {
            var2_2 = k.d;
        } else lbl-1000:
        // 2 sources

        {
            var2_2 = k.a;
        }
        if (this.mSensorRotation != var2_2) {
            this.mSensorRotation = var2_2;
            this.mDisplayRotation = k.a(SystemDisplayInfo.getDisplayRotationDegree());
            this.notifyOrientationChanged();
        }
    }

    @Override
    public void onTimeout() {
        k k2 = k.a(SystemDisplayInfo.getDisplayRotationDegree());
        if (this.mDisplayRotation == k2) {
            return;
        }
        this.mDisplayRotation = k2;
        if (this.mSensorRotation == null) {
            this.mSensorRotation = this.getSensorRotationByDisplayRotation(k2);
        }
        this.notifyOrientationChanged();
    }

    private synchronized void notifyOrientationChanged() {
        if (this.mListenerPtr == 0L) {
            return;
        }
        int n2 = this.getSensorRotationCorrection() != null ? this.getSensorRotationCorrection().mValue : (this.mSensorRotation != null ? this.mSensorRotation.mValue : 0);
        int n3 = this.mDisplayRotation != null ? this.mDisplayRotation.mValue : 0;
        SystemNotificationMonitor.nativeSensorChanged(this.mListenerPtr, n2, n3);
    }

    private k getSensorRotationByDisplayRotation(k displayRotation) {
        if (displayRotation == null) {
            return k.a;
        }
        switch (displayRotation) {
            case b: {
                return k.d;
            }
            case c: {
                return k.c;
            }
            case d: {
                return k.b;
            }
        }
        return k.a;
    }

    private k getSensorRotationCorrection() {
        if (this.mListenerPtr == 0L) {
            return null;
        }
        int n2 = SystemNotificationMonitor.nativeGetGravitySensorRotationCorrection(this.mListenerPtr);
        if (k.b(n2)) {
            return k.a(n2);
        }
        return null;
    }

    private static native void nativeSensorChanged(long var0, int var2, int var3);

    private static synchronized native int nativeGetGravitySensorRotationCorrection(long var0);
}

