/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2.capture;

import android.media.projection.MediaProjection;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videoproducer2.capture.NativeScreenCaptureListener;
import com.tencent.liteav.videoproducer2.capture.j;
import com.tencent.rtmp.video.VirtualDisplayManagerProxy;

@JNINamespace(value="liteav::video")
public class NativeScreenCapture {
    private static final String TAG = "NativeScreenCapture";
    private NativeScreenCaptureListener mListener;
    private j mScreenCaptureBridge;
    private Surface mSurface;
    private MediaProjection mMediaProjection;
    static boolean sIsCheck = false;
    static boolean sIsCaptureClassExist = false;

    public NativeScreenCapture(Surface surface, MediaProjection mediaProjection, NativeScreenCaptureListener listener) {
        this.mSurface = surface;
        this.mMediaProjection = mediaProjection;
        this.mListener = listener;
    }

    public void startVirtualDisplaySync(int width, int height) {
        if (!NativeScreenCapture.checkIfScreenCaptureClassExist()) {
            this.mListener.onClassNotFound();
            return;
        }
        if (this.mScreenCaptureBridge == null) {
            this.mScreenCaptureBridge = new j(this.mSurface, width, height, this.mMediaProjection, this.mListener);
        }
        j j2 = this.mScreenCaptureBridge;
        VirtualDisplayManagerProxy.getInstance().startVirtualDisplaySync(j2.a, j2.c, j2.d, j2.b, j2.f);
    }

    public void updateVirtualDisplaySync(int width, int height, boolean needRecreate) {
        if (!NativeScreenCapture.checkIfScreenCaptureClassExist()) {
            this.mListener.onClassNotFound();
            return;
        }
        if (this.mScreenCaptureBridge == null) {
            LiteavLog.e(TAG, "Must start first!");
            return;
        }
        j j2 = this.mScreenCaptureBridge;
        this.mScreenCaptureBridge.c = width;
        j2.d = height;
        LiteavLog.i("ScreenCaptureBridge", "updateVirtualDisplaySync:[wxh:" + width + "x" + height + "|restart:" + needRecreate + "]");
        if (j2.e == null || needRecreate) {
            j j3 = j2;
            if (j3.e != null) {
                j3.e.release();
                j3.e = null;
            }
            VirtualDisplayManagerProxy.getInstance().updateVirtualDisplaySizeSync(j3.a, j3.c, j3.d, j3.f);
            return;
        }
        j2.e.resize(width, height);
    }

    public void stopVirtualDisplaySync() {
        if (!NativeScreenCapture.checkIfScreenCaptureClassExist()) {
            this.mListener.onClassNotFound();
            return;
        }
        if (this.mScreenCaptureBridge != null) {
            j j2 = this.mScreenCaptureBridge;
            if (j2.e != null) {
                j2.e.release();
                j2.e = null;
            }
            VirtualDisplayManagerProxy.getInstance().stopVirtualDisplaySync(j2.a);
            this.mScreenCaptureBridge = null;
        }
    }

    private static boolean checkIfScreenCaptureClassExist() {
        if (sIsCheck) {
            return sIsCaptureClassExist;
        }
        boolean bl = false;
        try {
            Class.forName("com.tencent.rtmp.video.ScreenCaptureService");
            Class.forName("com.tencent.rtmp.video.TXScreenCapture");
            bl = true;
            LiteavLog.i(TAG, "Detect screen capture class!");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LiteavLog.e(TAG, "Detect screen capture class failed!");
        }
        sIsCaptureClassExist = bl;
        sIsCheck = true;
        return bl;
    }
}

