/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2.capture;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.videoproducer2.capture.f;
import com.tencent.liteav.videoproducer2.capture.g;
import com.tencent.liteav.videoproducer2.capture.h;
import com.tencent.liteav.videoproducer2.capture.i;

@JNINamespace(value="liteav::video")
public class NativeScreenCaptureListener
implements SurfaceTexture.OnFrameAvailableListener {
    private final CustomHandler mCallbackHandler;
    private long mNativeHandle;

    public NativeScreenCaptureListener(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        Looper looper = Looper.myLooper();
        this.mCallbackHandler = new CustomHandler(looper);
    }

    public synchronized void resetNativeHandle() {
        this.mNativeHandle = 0L;
    }

    public Handler getCallbackHandler() {
        return this.mCallbackHandler;
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.mCallbackHandler.runOrPost(f.a(this, surfaceTexture));
    }

    public void onStartFinish(boolean success, boolean isPermissionDenied) {
        this.mCallbackHandler.runOrPost(g.a(this, success, isPermissionDenied));
    }

    public void onCaptureError() {
        this.mCallbackHandler.runOrPost(h.a(this));
    }

    public void onClassNotFound() {
        this.mCallbackHandler.runOrPost(i.a(this));
    }

    private synchronized void notifyFrameAvailable(SurfaceTexture surfaceTexture) {
        if (this.mNativeHandle != 0L) {
            NativeScreenCaptureListener.nativeOnFrameAvailable(this.mNativeHandle, surfaceTexture);
        }
    }

    private synchronized void notifyStartFinish(boolean success, boolean isPermissionDenied) {
        if (this.mNativeHandle != 0L) {
            NativeScreenCaptureListener.nativeOnStartFinish(this.mNativeHandle, success, isPermissionDenied);
        }
    }

    private synchronized void notifyCaptureError() {
        if (this.mNativeHandle != 0L) {
            NativeScreenCaptureListener.nativeOnCaptureError(this.mNativeHandle);
        }
    }

    private synchronized void notifyClassNotFound() {
        if (this.mNativeHandle != 0L) {
            NativeScreenCaptureListener.nativeOnClassNotFound(this.mNativeHandle);
        }
    }

    private static native void nativeOnStartFinish(long var0, boolean var2, boolean var3);

    private static native void nativeOnCaptureError(long var0);

    private static native void nativeOnClassNotFound(long var0);

    private static native void nativeOnFrameAvailable(long var0, SurfaceTexture var2);

    static /* synthetic */ void lambda$onStartFinish$1(NativeScreenCaptureListener this_, boolean success, boolean isPermissionDenied) {
        this_.notifyStartFinish(success, isPermissionDenied);
    }

    static /* synthetic */ void lambda$onFrameAvailable$0(NativeScreenCaptureListener this_, SurfaceTexture surfaceTexture) {
        this_.notifyFrameAvailable(surfaceTexture);
    }

    static /* synthetic */ void access$lambda$0(NativeScreenCaptureListener nativeScreenCaptureListener) {
        nativeScreenCaptureListener.notifyCaptureError();
    }

    static /* synthetic */ void access$lambda$1(NativeScreenCaptureListener nativeScreenCaptureListener) {
        nativeScreenCaptureListener.notifyClassNotFound();
    }
}

