/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.daisy;

import android.content.Context;
import android.media.AudioManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.l;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyAudioKaraokeFeatureKit;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyAudioKit;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyFeatureKitManager;
import com.tencent.trtc.hardwareearmonitor.daisy.IDaisyAudioKitCallback;
import java.util.List;

@JNINamespace(value="liteav::extensions")
public class HardwareEarMonitorDaisy
implements IDaisyAudioKitCallback {
    private static final String TAG = "HardwareEarMonitorDaisy";
    private Context mContext;
    private DaisyAudioKit mDaisyAudioKit;
    private DaisyAudioKaraokeFeatureKit mDaisyKaraokeKit;
    private Object mLock = new Object();
    private long mNativeHardwareEarMonitorHandle = 0L;
    private AudioManager mAudioManager;
    private l mTaskRunner;

    public static HardwareEarMonitorDaisy create(long nativeHardwareEarMonitorHandle) {
        return new HardwareEarMonitorDaisy(nativeHardwareEarMonitorHandle);
    }

    public static boolean isAudioKitSupport() {
        return DaisyFeatureKitManager.isAudioKitSupport(ContextUtils.getApplicationContext());
    }

    public boolean isKaraokeServiceSupport() {
        return this.mDaisyAudioKit.isFeatureSupported(DaisyAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
    }

    public int[] getKaraokeSupportedServices() {
        List<Integer> list = this.mDaisyAudioKit.getSupportedFeatures();
        if (list == null) {
            return null;
        }
        int[] nArray = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            nArray[i2] = list.get(i2);
        }
        return nArray;
    }

    public void createKaraokeService() {
        this.mDaisyKaraokeKit = (DaisyAudioKaraokeFeatureKit)this.mDaisyAudioKit.createFeature(DaisyAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.mNativeHardwareEarMonitorHandle = 0L;
        }
        if (this.mDaisyAudioKit != null) {
            this.mDaisyAudioKit.destroy();
            this.mDaisyAudioKit = null;
        }
        if (this.mDaisyKaraokeKit != null) {
            this.mDaisyKaraokeKit.destroy();
            this.mDaisyKaraokeKit = null;
        }
    }

    public int enableKaraoke(boolean enable) {
        if (this.mDaisyKaraokeKit == null) {
            return 1806;
        }
        return this.mDaisyKaraokeKit.enableKaraokeFeature(enable);
    }

    public boolean setAudioParams(String params) {
        try {
            this.mAudioManager.setParameters(params);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int setReverberation(int value) {
        if (this.mDaisyKaraokeKit == null) {
            return 1806;
        }
        return this.mDaisyKaraokeKit.setParameter(DaisyAudioKaraokeFeatureKit.ParameName.CMD_SET_AUDIO_EFFECT_MODE_BASE, value);
    }

    private int setEqualizer(int value) {
        if (this.mDaisyKaraokeKit == null) {
            return 1806;
        }
        return this.mDaisyKaraokeKit.setParameter(DaisyAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_EQUALIZER_MODE, value);
    }

    private int setVolume(int value) {
        if (this.mDaisyKaraokeKit == null) {
            return 1806;
        }
        return this.mDaisyKaraokeKit.setParameter(DaisyAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, value);
    }

    public boolean isHardwareEarMonitorSupported() {
        if (this.mDaisyAudioKit == null) {
            return false;
        }
        return this.mDaisyAudioKit.isFeatureSupported(DaisyAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
    }

    public int getKaraokeLatency() {
        int n2;
        if (this.mDaisyKaraokeKit == null) {
            return -1;
        }
        try {
            n2 = this.mDaisyKaraokeKit.getKaraokeLatency();
        }
        catch (Throwable throwable) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public void onResult(final int resultCode) {
        this.mTaskRunner.a(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                Object object = HardwareEarMonitorDaisy.this.mLock;
                synchronized (object) {
                    HardwareEarMonitorDaisy.nativeHandleResult(HardwareEarMonitorDaisy.this.mNativeHardwareEarMonitorHandle, resultCode);
                    return;
                }
            }
        });
    }

    public HardwareEarMonitorDaisy(long nativeHardwareEarMonitorHandle) {
        this.mNativeHardwareEarMonitorHandle = nativeHardwareEarMonitorHandle;
        this.mAudioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        this.mContext = ContextUtils.getApplicationContext();
        this.mTaskRunner = new l();
        this.mDaisyAudioKit = new DaisyAudioKit(ContextUtils.getApplicationContext(), this);
        this.mDaisyAudioKit.initialize();
    }

    private static native void nativeHandleResult(long var0, int var2);
}

