/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.oplus;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.trtc.hardwareearmonitor.oplus.OplusKaraokeServiceAidlInterface;

@JNINamespace(value="liteav::extensions")
public class HardwareEarMonitorOplus {
    private static final String TAG = "HardwareEarMonitorOplus";
    private static final String AUTH_URI = "content://com.oplus.ocs.out.OpenCapabilityThirdProvider/oplus";
    private long mNativeHardwareEarMonitorHandle = 0L;
    private AudioManager mAudioManager;
    private Context mContext;
    private OplusKaraokeServiceAidlInterface mKaraokeServiceInterface;
    private Object mLock = new Object();
    private KaraokeServiceConnection mConnection;
    private Intent mServiceIntent;
    private l mTaskRunner;
    private static final int OPEN_CAPABILITY_THIRD_PROVIDER_NOT_FOUND = 1013;
    private static final int ON_BIND_EXCEPTION = 1012;
    private static final int AUTHENTICATE_FAIL = 1002;
    private static final int KARAOKE_SUCCESS = 1000;
    private static final int KARAOKE_MESSAGE_CODE = 3000;

    public static HardwareEarMonitorOplus create(long nativeHardwareEarMonitorHandle) {
        return new HardwareEarMonitorOplus(nativeHardwareEarMonitorHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.mNativeHardwareEarMonitorHandle = 0L;
        }
        try {
            this.mContext.unbindService((ServiceConnection)this.mConnection);
        }
        catch (Throwable throwable) {
            LiteavLog.i(TAG, "destroy ex:" + throwable.getMessage());
        }
        this.mConnection = null;
        this.mKaraokeServiceInterface = null;
    }

    public boolean setAudioParams(String params) {
        try {
            this.mAudioManager.setParameters(params);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int getUidFromPackage() {
        int n2 = 0;
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                n2 = this.mContext.getPackageManager().getPackageUid(this.mContext.getPackageName(), 0);
            }
        }
        catch (Throwable throwable) {
            n2 = 0;
        }
        return n2;
    }

    public boolean systemFeatureSupported(String featureName) {
        boolean bl = false;
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                bl = this.mContext.getPackageManager().hasSystemFeature(featureName);
            }
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public void notifyResult(final int resultCode) {
        this.mTaskRunner.a(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                Object object = HardwareEarMonitorOplus.this.mLock;
                synchronized (object) {
                    HardwareEarMonitorOplus.nativeHandleResult(HardwareEarMonitorOplus.this.mNativeHardwareEarMonitorHandle, resultCode);
                    return;
                }
            }
        });
    }

    public void authCheck(String mediaName) {
        Uri uri = Uri.parse((String)AUTH_URI);
        HardwareEarMonitorOplus hardwareEarMonitorOplus = this;
        Messenger messenger = new Messenger(new Handler(hardwareEarMonitorOplus.mContext.getMainLooper()){

            public final void handleMessage(Message message) {
                try {
                    super.handleMessage(message);
                    int n2 = message.getData().getInt("result_code");
                    HardwareEarMonitorOplus.this.notifyResult(n2);
                    return;
                }
                catch (Throwable throwable) {
                    LiteavLog.i(HardwareEarMonitorOplus.TAG, "authCheck ex:" + throwable.getMessage());
                    HardwareEarMonitorOplus.this.notifyResult(1002);
                    return;
                }
            }
        });
        Bundle bundle = new Bundle();
        bundle.putBinder("callback", messenger.getBinder());
        Bundle bundle2 = null;
        try {
            bundle2 = this.mContext.getContentResolver().call(uri, "auth", mediaName, bundle);
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "component is not exist or not visible ex:" + throwable.getMessage());
            this.notifyResult(1013);
        }
        if (bundle2 == null) {
            LiteavLog.e(TAG, "retBundle is null");
            this.notifyResult(1013);
        }
    }

    public int getOplusOSVersionInt() {
        int n2 = 0;
        try {
            Class<?> clazz = Class.forName("com.oplus.os.OplusBuild");
            n2 = (Integer)clazz.getDeclaredMethod("getOplusOSVERSION", new Class[0]).invoke(clazz, new Object[0]);
        }
        catch (Throwable throwable) {
            LiteavLog.i(TAG, "getOplusOSVersionInt ex:" + throwable.getMessage());
        }
        return n2;
    }

    public void bindKaraokeService(String servicePackageName, String serviceName, String descName) {
        this.mServiceIntent = new Intent();
        LiteavLog.i(TAG, "bindKaraokeService service package name:" + servicePackageName + " service name:" + serviceName + " android os:" + Build.VERSION.SDK_INT + " oplus os:" + this.getOplusOSVersionInt());
        this.mServiceIntent.setPackage(servicePackageName);
        this.mServiceIntent.setAction(serviceName);
        this.mConnection.setDescName(descName);
        try {
            this.mContext.bindService(this.mServiceIntent, (ServiceConnection)this.mConnection, 1);
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.i(TAG, "bindKaraokeService ex:" + throwable.getMessage());
            this.notifyResult(1012);
            return;
        }
    }

    public String getManifestMeta(String metaName) {
        String string = "";
        try {
            string = this.mContext.getPackageManager().getApplicationInfo((String)this.mContext.getPackageName(), (int)128).metaData.getString(metaName);
        }
        catch (Throwable throwable) {
            LiteavLog.i(TAG, "getManifestMeta ex:" + throwable.getMessage());
        }
        return string;
    }

    public void setActiveClient(String packageName) {
        if (this.mKaraokeServiceInterface != null) {
            try {
                this.mKaraokeServiceInterface.setActiveClient(packageName);
                return;
            }
            catch (Throwable throwable) {
                LiteavLog.i(TAG, "setActiveClient ex:" + throwable.getMessage());
            }
        }
    }

    public HardwareEarMonitorOplus(long nativeSystemAudioKit) {
        this.mNativeHardwareEarMonitorHandle = nativeSystemAudioKit;
        this.mAudioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        this.mContext = ContextUtils.getApplicationContext();
        this.mConnection = new KaraokeServiceConnection();
        this.mTaskRunner = new l();
    }

    private static native void nativeHandleResult(long var0, int var2);

    public class KaraokeServiceConnection
    implements ServiceConnection {
        private String mDescName;

        void setDescName(String descName) {
            this.mDescName = descName;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            OplusKaraokeServiceAidlInterface.Stub.setDESCRIPTOR(this.mDescName);
            HardwareEarMonitorOplus.this.mKaraokeServiceInterface = OplusKaraokeServiceAidlInterface.Stub.asInterface(service);
            if (HardwareEarMonitorOplus.this.mKaraokeServiceInterface != null) {
                LiteavLog.i(HardwareEarMonitorOplus.TAG, "mKaraokeServiceInterface Create Success");
                HardwareEarMonitorOplus.this.notifyResult(1000);
                return;
            }
            LiteavLog.i(HardwareEarMonitorOplus.TAG, "mKaraokeServiceInterface Create Failed");
            HardwareEarMonitorOplus.this.notifyResult(1012);
        }

        public void onServiceDisconnected(ComponentName name) {
            HardwareEarMonitorOplus.this.mKaraokeServiceInterface = null;
            LiteavLog.i(HardwareEarMonitorOplus.TAG, "onServiceDisconnected");
            HardwareEarMonitorOplus.this.notifyResult(1012);
        }
    }
}

